/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallInfo;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.nio.Buffer;
import java.nio.ByteOrder;

public final class HeapInvocationBuffer
implements InvocationBuffer {
    private static final int FFI_SIZEOF_ARG = Platform.getPlatform().addressSize() / 8;
    private static final int PARAM_SIZE = 8;
    private static final Encoder encoder = HeapInvocationBuffer.getEncoder();
    private final CallInfo info;
    private final byte[] buffer;
    private ObjectBuffer objectBuffer = null;
    private int paramOffset = 0;
    private int paramIndex = 0;

    public HeapInvocationBuffer(CallInfo callInfo) {
        this.info = callInfo;
        this.buffer = new byte[encoder.getBufferSize(callInfo)];
    }

    public HeapInvocationBuffer(Function function) {
        this.info = function;
        this.buffer = new byte[encoder.getBufferSize(function)];
    }

    byte[] array() {
        return this.buffer;
    }

    ObjectBuffer objectBuffer() {
        return this.objectBuffer;
    }

    public final void putByte(int n) {
        this.paramOffset = encoder.putByte(this.buffer, this.paramOffset, n);
        ++this.paramIndex;
    }

    public final void putShort(int n) {
        this.paramOffset = encoder.putShort(this.buffer, this.paramOffset, n);
        ++this.paramIndex;
    }

    public final void putInt(int n) {
        this.paramOffset = encoder.putInt(this.buffer, this.paramOffset, n);
        ++this.paramIndex;
    }

    public final void putLong(long l) {
        this.paramOffset = encoder.putLong(this.buffer, this.paramOffset, l);
        ++this.paramIndex;
    }

    public final void putFloat(float f) {
        this.paramOffset = encoder.putFloat(this.buffer, this.paramOffset, f);
        ++this.paramIndex;
    }

    public final void putDouble(double d) {
        this.paramOffset = encoder.putDouble(this.buffer, this.paramOffset, d);
        ++this.paramIndex;
    }

    public final void putAddress(long l) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, l);
        ++this.paramIndex;
    }

    private final ObjectBuffer getObjectBuffer() {
        if (this.objectBuffer == null) {
            this.objectBuffer = new ObjectBuffer();
        }
        return this.objectBuffer;
    }

    public final void putArray(byte[] byArray, int n, int n2, int n3) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, byArray, n, n2, n3);
    }

    public final void putArray(short[] sArray, int n, int n2, int n3) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, sArray, n, n2, n3);
    }

    public final void putArray(int[] nArray, int n, int n2, int n3) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, nArray, n, n2, n3);
    }

    public final void putArray(long[] lArray, int n, int n2, int n3) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, lArray, n, n2, n3);
    }

    public final void putArray(float[] fArray, int n, int n2, int n3) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, fArray, n, n2, n3);
    }

    public final void putArray(double[] dArray, int n, int n2, int n3) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, dArray, n, n2, n3);
    }

    public final void putDirectBuffer(Buffer buffer, int n, int n2) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putDirectBuffer(this.paramIndex++, buffer, n, n2);
    }

    public final void putStruct(byte[] byArray, int n) {
        Type type = this.info.getParameterType(this.paramIndex);
        if (encoder.isRaw()) {
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset, type.alignment());
            System.arraycopy(byArray, n, this.buffer, this.paramOffset, type.size());
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset + type.size(), FFI_SIZEOF_ARG);
        } else {
            this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
            this.getObjectBuffer().putArray(this.paramIndex, byArray, n, type.size(), 1);
        }
        ++this.paramIndex;
    }

    public final void putStruct(long l) {
        Type type = this.info.getParameterType(this.paramIndex);
        if (encoder.isRaw()) {
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset, type.alignment());
            MemoryIO.getInstance().getByteArray(l, this.buffer, this.paramOffset, type.size());
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset + type.size(), FFI_SIZEOF_ARG);
        } else {
            this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, l);
        }
        ++this.paramIndex;
    }

    public final void putJNIEnvironment() {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putJNI(this.paramIndex++, 0x1000000);
    }

    private static final Encoder getEncoder() {
        if (Platform.getPlatform().getCPU() == Platform.CPU.I386) {
            return Foreign.getInstance().isRawParameterPackingEnabled() ? HeapInvocationBuffer.newI386RawEncoder() : HeapInvocationBuffer.newLE32Encoder();
        }
        if (Platform.getPlatform().addressSize() == 64) {
            return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? HeapInvocationBuffer.newBE64Encoder() : HeapInvocationBuffer.newLE64Encoder();
        }
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? HeapInvocationBuffer.newBE32Encoder() : HeapInvocationBuffer.newLE32Encoder();
    }

    private static final Encoder newI386RawEncoder() {
        return new I386RawEncoder();
    }

    private static final Encoder newLE32Encoder() {
        return new DefaultEncoder(LE32ArrayIO.INSTANCE);
    }

    private static final Encoder newLE64Encoder() {
        return new DefaultEncoder(LE64ArrayIO.INSTANCE);
    }

    private static final Encoder newBE32Encoder() {
        return new DefaultEncoder(BE32ArrayIO.INSTANCE);
    }

    private static final Encoder newBE64Encoder() {
        return new DefaultEncoder(BE64ArrayIO.INSTANCE);
    }

    private static final int FFI_ALIGN(int n, int n2) {
        return (n - 1 | n2 - 1) + 1;
    }

    private static abstract class ArrayIO {
        private ArrayIO() {
        }

        public abstract void putByte(byte[] var1, int var2, int var3);

        public abstract void putShort(byte[] var1, int var2, int var3);

        public abstract void putInt(byte[] var1, int var2, int var3);

        public abstract void putLong(byte[] var1, int var2, long var3);

        public final void putFloat(byte[] byArray, int n, float f) {
            this.putInt(byArray, n, Float.floatToRawIntBits(f));
        }

        public final void putDouble(byte[] byArray, int n, double d) {
            this.putLong(byArray, n, Double.doubleToRawLongBits(d));
        }

        public abstract void putAddress(byte[] var1, int var2, long var3);
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE32ArrayIO();

        private BE32ArrayIO() {
        }

        public void putAddress(byte[] byArray, int n, long l) {
            byArray[n + 0] = (byte)(l >> 24);
            byArray[n + 1] = (byte)(l >> 16);
            byArray[n + 2] = (byte)(l >> 8);
            byArray[n + 3] = (byte)l;
        }
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE64ArrayIO();

        private BE64ArrayIO() {
        }

        public void putAddress(byte[] byArray, int n, long l) {
            this.putLong(byArray, n, l);
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public final void putByte(byte[] byArray, int n, int n2) {
            byArray[n] = (byte)n2;
        }

        public final void putShort(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 8);
            byArray[n + 1] = (byte)n2;
        }

        public final void putInt(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 24);
            byArray[n + 1] = (byte)(n2 >> 16);
            byArray[n + 2] = (byte)(n2 >> 8);
            byArray[n + 3] = (byte)n2;
        }

        public final void putLong(byte[] byArray, int n, long l) {
            byArray[n + 0] = (byte)(l >> 56);
            byArray[n + 1] = (byte)(l >> 48);
            byArray[n + 2] = (byte)(l >> 40);
            byArray[n + 3] = (byte)(l >> 32);
            byArray[n + 4] = (byte)(l >> 24);
            byArray[n + 5] = (byte)(l >> 16);
            byArray[n + 6] = (byte)(l >> 8);
            byArray[n + 7] = (byte)l;
        }
    }

    private static final class DefaultEncoder
    extends Encoder {
        private final ArrayIO io;

        public DefaultEncoder(ArrayIO arrayIO) {
            this.io = arrayIO;
        }

        public final boolean isRaw() {
            return false;
        }

        public final int getBufferSize(CallInfo callInfo) {
            return callInfo.getParameterCount() * 8;
        }

        public final int putByte(byte[] byArray, int n, int n2) {
            this.io.putByte(byArray, n, n2);
            return n + 8;
        }

        public final int putShort(byte[] byArray, int n, int n2) {
            this.io.putShort(byArray, n, n2);
            return n + 8;
        }

        public final int putInt(byte[] byArray, int n, int n2) {
            this.io.putInt(byArray, n, n2);
            return n + 8;
        }

        public final int putLong(byte[] byArray, int n, long l) {
            this.io.putLong(byArray, n, l);
            return n + 8;
        }

        public final int putFloat(byte[] byArray, int n, float f) {
            this.io.putFloat(byArray, n, f);
            return n + 8;
        }

        public final int putDouble(byte[] byArray, int n, double d) {
            this.io.putDouble(byArray, n, d);
            return n + 8;
        }

        public final int putAddress(byte[] byArray, int n, long l) {
            this.io.putAddress(byArray, n, l);
            return n + 8;
        }
    }

    private static abstract class Encoder {
        private Encoder() {
        }

        public abstract boolean isRaw();

        public abstract int getBufferSize(CallInfo var1);

        public abstract int putByte(byte[] var1, int var2, int var3);

        public abstract int putShort(byte[] var1, int var2, int var3);

        public abstract int putInt(byte[] var1, int var2, int var3);

        public abstract int putLong(byte[] var1, int var2, long var3);

        public abstract int putFloat(byte[] var1, int var2, float var3);

        public abstract int putDouble(byte[] var1, int var2, double var3);

        public abstract int putAddress(byte[] var1, int var2, long var3);
    }

    private static final class I386RawEncoder
    extends Encoder {
        private static final ArrayIO IO = LE32ArrayIO.INSTANCE;

        private I386RawEncoder() {
        }

        public final boolean isRaw() {
            return true;
        }

        public final int getBufferSize(CallInfo callInfo) {
            return callInfo.getRawParameterSize();
        }

        public final int putByte(byte[] byArray, int n, int n2) {
            IO.putByte(byArray, n, n2);
            return n + 4;
        }

        public final int putShort(byte[] byArray, int n, int n2) {
            IO.putShort(byArray, n, n2);
            return n + 4;
        }

        public final int putInt(byte[] byArray, int n, int n2) {
            IO.putInt(byArray, n, n2);
            return n + 4;
        }

        public final int putLong(byte[] byArray, int n, long l) {
            IO.putLong(byArray, n, l);
            return n + 8;
        }

        public final int putFloat(byte[] byArray, int n, float f) {
            IO.putFloat(byArray, n, f);
            return n + 4;
        }

        public final int putDouble(byte[] byArray, int n, double d) {
            IO.putDouble(byArray, n, d);
            return n + 8;
        }

        public final int putAddress(byte[] byArray, int n, long l) {
            IO.putAddress(byArray, n, l);
            return n + 4;
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE32ArrayIO();

        private LE32ArrayIO() {
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            byArray[n] = (byte)l;
            byArray[n + 1] = (byte)(l >> 8);
            byArray[n + 2] = (byte)(l >> 16);
            byArray[n + 3] = (byte)(l >> 24);
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE64ArrayIO();

        private LE64ArrayIO() {
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putLong(byArray, n, l);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final void putByte(byte[] byArray, int n, int n2) {
            byArray[n] = (byte)n2;
        }

        public final void putShort(byte[] byArray, int n, int n2) {
            byArray[n] = (byte)n2;
            byArray[n + 1] = (byte)(n2 >> 8);
        }

        public final void putInt(byte[] byArray, int n, int n2) {
            byArray[n] = (byte)n2;
            byArray[n + 1] = (byte)(n2 >> 8);
            byArray[n + 2] = (byte)(n2 >> 16);
            byArray[n + 3] = (byte)(n2 >> 24);
        }

        public final void putLong(byte[] byArray, int n, long l) {
            byArray[n] = (byte)l;
            byArray[n + 1] = (byte)(l >> 8);
            byArray[n + 2] = (byte)(l >> 16);
            byArray[n + 3] = (byte)(l >> 24);
            byArray[n + 4] = (byte)(l >> 32);
            byArray[n + 5] = (byte)(l >> 40);
            byArray[n + 6] = (byte)(l >> 48);
            byArray[n + 7] = (byte)(l >> 56);
        }
    }
}

